/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block;

import com.mojang.datafixers.util.Pair;
import com.renyigesai.immortalers_delight.api.PlateBaseBlock;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class StackedFoodBlock
extends HorizontalDirectionalBlock
implements PlateBaseBlock {
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)16);
    public static final VoxelShape BOX = StackedFoodBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    public final Supplier<Item> servingItem;
    public final Supplier<Item> pileItem;
    public final int pilePerItem;

    public StackedFoodBlock(BlockBehaviour.Properties p_54120_, Supplier<Item> servingItem, Supplier<Item> pileItem, int pilePerItem) {
        super(p_54120_);
        this.servingItem = servingItem;
        this.pilePerItem = pilePerItem;
        this.pileItem = pileItem;
        super.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BITES, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack hand_stack = player.m_21120_(hand);
        if (hand_stack.m_150930_(this.pileItem.get())) {
            return this.pileUp(state, level, pos, player, hand);
        }
        if (this.isCuttable(hand_stack)) {
            return this.cut(state, level, pos, player);
        }
        if (this.isEdible() && this.eat(state, level, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        this.messageOnUse(player);
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public boolean isCuttable(ItemStack stack) {
        return stack.m_204117_(ModTags.KNIVES);
    }

    public boolean isEdible() {
        return true;
    }

    public int getMaxBites() {
        return BITES.m_6908_().size() - 1;
    }

    public int getPileBitesPerItem() {
        return this.pilePerItem;
    }

    public ItemStack getPileItem() {
        return new ItemStack((ItemLike)this.pileItem.get());
    }

    public void messageOnUse(Player player) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)("tooltip.immortalers_delight.cut_" + BuiltInRegistries.f_256975_.m_7981_((Object)this).m_135815_().replace('/', '.'))), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean eat(BlockState state, Level level, BlockPos pos, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (bites < this.getMaxBites()) {
            if (!player.m_36391_(false)) return false;
            this.setBlock(bites, state, level, pos);
            player.m_36324_().m_38712_(this.servingItem.get(), new ItemStack((ItemLike)this.servingItem.get()));
            this.addFoodPoisonEffect(new ItemStack((ItemLike)this.servingItem.get()), level, (LivingEntity)player);
            level.m_142346_((Entity)player, GameEvent.f_157806_, pos);
            level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
            return true;
        } else {
            level.m_46961_(pos, false);
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)Items.f_42399_), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (double)0.0, (double)0.0, (double)0.0);
            level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        }
        return true;
    }

    public InteractionResult cut(BlockState state, Level level, BlockPos pos, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        Direction direction = player.m_6350_().m_122424_();
        if (bites < this.getMaxBites()) {
            this.setBlock(bites, state, level, pos);
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)this.servingItem.get()), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        } else {
            level.m_7471_(pos, false);
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)Items.f_42399_), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        }
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult pileUp(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand) {
        int pile = this.pilePerItem;
        int bites = (Integer)pState.m_61143_((Property)BITES);
        ItemStack hand = pPlayer.m_21120_(pHand);
        if (bites - pile >= 0) {
            this.setBlock(bites - 1 - pile, pState, pLevel, pPos);
            if (!pPlayer.m_7500_()) {
                hand.m_41774_(1);
            }
            pLevel.m_247517_(null, pPos, SoundEvents.f_12633_, SoundSource.BLOCKS);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void addFoodPoisonEffect(ItemStack p_21064_, Level p_21065_, LivingEntity p_21066_) {
        Item item = p_21064_.m_41720_();
        if (item.m_41472_()) {
            for (Pair pair : p_21064_.getFoodProperties(p_21066_).m_38749_()) {
                if (p_21065_.f_46443_ || pair.getFirst() == null) continue;
                if (((MobEffectInstance)pair.getFirst()).m_19544_() == ImmortalersDelightMobEffect.INEBRIATED.get() && p_21066_.m_21023_((MobEffect)ImmortalersDelightMobEffect.INEBRIATED.get())) {
                    MobEffectInstance instance = p_21066_.m_21124_((MobEffect)ImmortalersDelightMobEffect.INEBRIATED.get());
                    p_21066_.m_7292_(new MobEffectInstance(((MobEffectInstance)pair.getFirst()).m_19544_(), ((MobEffectInstance)pair.getFirst()).m_19557_() + instance.m_19557_(), Math.max(((MobEffectInstance)pair.getFirst()).m_19564_(), instance.m_19564_())));
                    continue;
                }
                p_21066_.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
    }

    public void setBlock(int variate, BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(variate + 1)), 3);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES, f_54117_});
    }

    @Override
    public boolean isEmptyPlate(BlockState state) {
        return ((Integer)state.m_61143_((Property)BITES)).intValue() == this.getMaxBites();
    }
}

